; sse_string4.asm
; znajdowanie znaku
extern print16b
extern printf
section .data
	string1   db	"qdacdekkfijlmdozabecdfgdklkmdddaffffffffdedeee",10,0 
	string2	db	"e",0
	string3	db	"a",0             
	fmt 		db 	"Znajdowanie wszystkich znaków '%s' i '%s' w:",10,0
	fmt_oc 	db 	"Znaleziono %ld znaki(-ów) '%s' i '%s'",10,0
	NL  		db 	10,0
section .bss
section .text							
	global main					
main:
push	rbp
mov	rbp,rsp

; wypisujemy szukane znaki
	mov 	rdi, fmt
	mov 	rsi, string2
	mov 	rdx, string3
	xor 	rax,rax
	call printf
; wypisujemy docelowy łańcuch
    	mov 	rdi, string1
    	xor 	rax,rax
    	call printf 
; przeszukujemy łańcuch i wypisujemy maskę
    	mov 	rdi, string1
    	mov 	rsi, string2
    	mov 	rdx, string3
    	call pcharsrch
; wypisujemy liczbę wystąpień string2
	mov 	rdi, fmt_oc
	mov 	rsi, rax
	mov 	rdx, string2
	mov 	rcx, string3
	call printf
; wyjście
    leave
    ret
;-------------------------------------------------------------
; funkcja do wyszukiwania i wypisywania maski
pcharsrch:           ; wyszukiwanie upakowanych znaków
push	rbp		
mov	rbp,rsp
    	sub	rsp,16      ; rezerwujemy miejsce na stosie na odłożenie xmm1
		xor 	r12,r12     ; do przechowywania bieżącej sumy wystąpień
    	xor 	rcx,rcx     ; do sygnalizowania końca
    	xor 	rbx,rbx     ; do obliczania adresów
    	mov 	rax,-16     ; do zliczania bajtów, unikamy ustawienia flagi
; budujemy zawartość xmm1, wczytujemy szukany znak
    	pxor 	xmm1,xmm1  	; zerujemy xmm1
	pinsrb 	xmm1,byte[rsi],0  	; pierwszy znak pod indeksem 0
	pinsrb 	xmm1,byte[rdx],1	; drugi znak pod indeksem 1
.loop:
    	add 		rax,16    	; unikamy ustawienia flagi ZF
    	mov 		rsi,16       	; jeśli brak końcowego zera, wypisujemy 16 bajtów
    	movdqu 	xmm2,[rdi+rbx]	; wczytujemy 16 bajtów łańcucha do xmm2
    	pcmpistrm xmm1,xmm2,40h 	;"równy każdy" i "maska bajtowa w xmm0'
    	setz  	cl            	; jeśli wykryto końcowe zero
; jeśli znaleziono końcowe 0, ustalamy pozycję
	cmp 	cl,0
	je 	.gotoprint   	; nie znaleziono końcowego zera
	; znaleziono końcowe zero
	; zostało mniej niż 16 bajtów
	; rdi zawiera adres łańcucha
	; rbx zawiera liczbę bajtów w dotychczas przetworzonych blokach
 	add 	rdi,rbx		; adres pozostałej części łańcucha
	push	rcx			; zapisywany przez wywołującego (rejestr cl w użyciu)
	call 	pstrlen     ; długość zwracana w rax
	pop		rcx			; zapisywany przez wywołującego
	dec 	rax			; długość bez końcowego zera
	mov 	rsi,rax		; długość pozostałych bajtów maski

; wypisywanie maski
.gotoprint:
	call print_mask
; obliczamy bieżącą sumę dopasowań
    	popcnt  	r13d,r13d      	; zliczamy bity o wartości 1
    	add 		r12d,r13d   	; zachowujemy liczbę wystąpień w r12d
    	or  		cl,cl       	; wykryto końcowe zero?
    	jnz 		.exit    
    	add 		rbx,16      	; przygotowujemy się na następnie 16 bajtów
    	jmp 		.loop
.exit:
		mov 	rdi, NL         ; dodajemy znak nowego wiersza
    	call 	printf
    	mov 	rax,r12         ; liczba wystąpień
leave
ret
;-------------------------------------------------------------
; funkcja do znajdowania końcowego zera
pstrlen:
push	rbp		
mov	rbp,rsp
	sub 		rsp,16 		; miejsce na zapisanie xmm0
   	movdqu 	[rbp-16],xmm0	; odkładamy xmm0 na stos
	mov		rax, -16		; unikamy późniejszego ustawienia flagi
	pxor      xmm0, xmm0	; szukamy zera (końca łańcucha)	
.loop:  add	rax, 16    	 ; unikamy ustawienia flagi ZF, kiedy rax = 0 po pcmpistri
	pcmpistri	xmm0, [rdi + rax], 0x08 ;'równy każdy'
	jnz     	.loop         	;znaleziono zero?
	add    	rax, rcx		; rax = wcześniej przetworzone bajty
                            ; rcx = bajty przetworzone w ostatniej pętli
    movdqu 	xmm0,[rbp-16]	; zdejmujemy xmm0 ze stosu
leave
ret
;-------------------------------------------------------------
; funkcja do wypisywania maski
; xmm0 zawiera maskę
; rsi zawiera liczbę bitów do wypisania (16 lub mniej)
print_mask:
push	rbp		
mov	rbp,rsp
	sub 		rsp,16 		; miejsce na zapisanie xmm0
    	call 	reverse_xmm0	; little endian
    	pmovmskb 	r13d,xmm0  	; przenosimy maskę bajtową do edx
    	movdqu 	[rbp-16],xmm1	; odkładamy xmm1 na stos ze względu na printf
    	push 	rdi        	; rdi zawiera string1
    	mov 		edi,r13d		; zawiera maskę do wypisania
    	push 	rdx			; zawiera maskę
    	push 	rcx        	; zawiera flagę końca łańcucha
    	call 	print16b
    	pop 		rcx
    	pop 		rdx
    	pop 		rdi
    	movdqu 	xmm1,[rbp-16]	;pop xmm1
leave
ret
;-------------------------------------------------------------
; funkcja do odwracania (tasowania) xmm0
reverse_xmm0:
section .data
; maska do odwracania
        .bytereverse db 15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0
section .text
push	rbp		
mov	rbp,rsp
    	sub     rsp,16
    	movdqu [rbp-16],xmm2		
    	movdqu xmm2,[.bytereverse]  	; wczytujemy maskę do xmm2
    	pshufb xmm0,xmm2            	; tasujemy
    	movdqu xmm2,[rbp-16]	    	; zdejmujemy xmm2 ze stosu
leave                           	; zwracamy przetasowany rejestr xmm0
ret
